/****************************************************************************
 **                                                                        **
 **  Various bitmap functions - Aron, 1998.                                **
 **                                                                        **
 ****************************************************************************/

// - szabvany fejlecfile-ok -------------------------------------------------
#include <stdio.h>
#include <math.h>
#include "\Librarie.s\Zlib\Zlib.h"

// - sajat fejlecfile-ok ----------------------------------------------------
#include "Defs.h"
#include "Bitmap.hpp"
#include "LogoData.hpp"
#include "Font.hpp"

// - implementacio ----------------------------------------------------------
byte shadetable[256*256],motionblurtable[256*256],Phongmap[256*256];;

// - tabla prekalkulalo -----------------------------------------------------
void InitTables(void)
{ 
	signed int i,j;
	float light;

	// altalanos tablazatok:
	for(i=0; i<256; i++) for(j=0; j<256; j++)
	{ 
		// shade tabla:
		*(shadetable + 256*i + j)= (byte)(i*(j/255.0));
		// motion blur tabla:
		*(motionblurtable + 256*i + j)= (byte)((i + j)>>1);
		// Phong tabla sin-osan befele novekvo intenzitassal:
		light= (float)(80.0*(1.0 - sin(1.5*M_PI + sqrt((i - 128.0)*(i - 128.0) + (j - 128.0)*(j - 128.0))*M_PI/2.0/80.0)));
		*(Phongmap + (256*i + j))= (byte)light;
	}
}

// - sztring rajzolo --------------------------------------------------------
dword cadder;
byte intensity;

void DrawString(char *string,byte *destptr,dword X,dword Y,dword color)
{ 
	static PROPORTIONAL_CHAR *fontptr= &letter[0];

	__asm
	{
					// parameterek: EBX -> string
                    //             EDI:= destptr, ESI:= fontptr,
                    //             ECX:= X, EDX:= Y

                    mov ebx,[string]
					mov edi,[destptr]
					mov esi,[fontptr]
					mov ecx,[X]
					mov edx,[Y]
					mov eax,[color]
					mov [intensity],al

					push ebp
                    mov ebp,ebx
                    imul edx,320
                    shl ecx,2
                    shl edx,2
                    add edi,ecx
                    add edi,edx                 // EDI:= destptr + 4*(320*Y + X)

	NxtChar:        movzx ecx,byte ptr [ebp]    // soron kovetkezo karakter
                    or cl,cl
                    jz StringEnd                // ha sztringvege jelet kap

                    cmp cl,' '
                    jne NotSpace
                    inc ebp
                    add edi,4*6                 // 6 pixel szeles space
                    jmp NxtChar

	NotSpace:       push edi                    // videoptr elmentese
                    sub cl,'a'                  // indexre konvertalas
                    imul ecx,181                // egy karakter merete [byte]

                    mov eax,320
                    sub al,byte ptr [esi + ecx]
                    shl eax,2
                    mov [cadder],eax            // cadder:= 4*(320 - szelesseg)

                    mov bh,13                   // konstans karaktermagassag
                    mov edx,ecx
                    inc edx                     // EDX -> data
	NxtRow:         mov bl,byte ptr [esi + ecx] // EDX:= szelesseg
	NxtPixel:       mov al,byte ptr [esi + edx]
                    or al,al
                    jz Transparent              // a 0-as pixel atlatszo
                    and al,[intensity]
                    mov ah,al
                    shl eax,8
                    mov al,ah
                    mov dword ptr [edi],eax
	Transparent:    inc edx
                    add edi,4                   // kovetkezo pixel
                    dec bl
                    jnz NxtPixel
                    add edi,[cadder]
                    dec bh
                    jnz NxtRow

                    pop edi                     // videoptr visszakerese
                    inc ebp                     // kovetkezo karakter
                    movzx eax,byte ptr [esi + ecx]
                    add eax,2
                    shl eax,2
                    add edi,eax                 // EDI:= oldvideoptr + 4*(szelesseg + 2)
                    jmp NxtChar
					
	StringEnd:      pop ebp
	}
}

// - wormhole effekt --------------------------------------------------------
byte wormholetable[2*320*180];
byte distanceadder,angleadder,distanceadder2,angleadder2;

void InitWormhole(void)
{ 
	signed int i,j,index;
	float x,y,z;

	for(j=1; j<DIVS+1; j++) for(i=0; i<SPOKES; i++)
	{ 
		// elso tablazat:
		z= (float)(0.5 - 4.0*log(2.0*j/DIVS));
		x= (float)(0250.0 + 500.0*j/DIVS * cos(2.0*M_PI*i/SPOKES));
		y= (float)(0100.0 + 200.0*j/DIVS * sin(2.0*M_PI*i/SPOKES) - z*STRETCH);

		if((x>=0) && (x<320) && (y>=0) && (y<180))
		{ 
			// index a tablazatban:
			index= 2*(320*(dword)y + (dword)x);

			// mapping koordinatak:
			wormholetable[index]= i % 256;
			wormholetable[index + 1]= j % 256;
		}
	}
}

void DrawWormHole(byte *destptr,byte *srcptr,byte *srcptr2,dword factor)
{ 
	distanceadder= (byte)factor; angleadder= (byte)factor;
	distanceadder2= (byte)(factor ^ 0xFFFFFFFF); angleadder2= (byte)(factor ^ 0xFFFFFFFF);

	__asm
	{
					// parameterek: EDI:= destptr, ESI:= srcptr, EAX:= srcptr2,
					//              ECX:= kezdo tablabejegyzes

					mov edi,[destptr]
					mov esi,[srcptr]
					mov eax,[srcptr2]
					mov ecx,[factor]

					push ebp
					xor ebx,ebx
					mov ebp,eax
					xor edx,edx
					xor ecx,ecx

		pNxtPix:	mov dx,word ptr wormholetable[ecx]		// U a DH-ba, V a DL-be
					mov bx,dx
					add dh,[distanceadder]
					add bh,[distanceadder2]
					add dl,[angleadder]						// EDX:= 4*(256*distance + angle)
					add bl,[angleadder2]					// EBX:= 4*(256*distance2 + angle2)

					movzx eax,byte ptr [esi + 4*edx + 0]	// B1 be
					add al,byte ptr [ebp + 4*ebx + 0]		// B2 be
					adc ah,0
					shl eax,7								// AH= B_new
					mov al,byte ptr [edi]
					mov al,motionblurtable[eax]				// AL= B_blur
					mov byte ptr [edi],al					// B ki

					movzx eax,byte ptr [esi + 4*edx + 1]	// G1 be
					add al,byte ptr [ebp + 4*ebx + 1]		// G2 be
					adc ah,0
					shl eax,7								// AH= G_new
					mov al,byte ptr [edi + 1]
					mov al,motionblurtable[eax]				// AL= G_blur
					mov byte ptr [edi + 1],al				// G ki

					movzx eax,byte ptr [esi + 4*edx + 2]	// R1 be
					add al,byte ptr [ebp + 4*ebx + 2]		// R2 be
					adc ah,0
					shl eax,7								// AH= R_new
					mov al,byte ptr [edi + 2]
					mov al,motionblurtable[eax]				// AL= R_blur
					mov byte ptr [edi + 2],al				// R ki

					add edi,4								// kovetkezo pixel
					add ecx,2
					cmp ecx,2*320*180
					jbe pNxtPix

					pop ebp
	}
}

// - textura zoomer ---------------------------------------------------------
dword zoomerstart,zoomerdelta;

void DrawZoomer(byte *destptr,byte *srcptr,float delta)
{ 
	static byte zoomery;

	// bal felso pont 8.8 fixpontos koordinataja:
	zoomerstart= (dword)((128.0 - delta*128.0) * 256.0);
	// 8.8 fixpontos delta:
	zoomerdelta= (dword)(delta*256.0);

	__asm
	{
					// parameterek: EDI->destptr, ESI->srcptr

					mov edi,[destptr]
					mov esi,[srcptr]

					push ebp
					xor ebx,ebx								// fixpontos szamlalok uritese
					mov ecx,[zoomerstart]
					mov [zoomery],180

		zNxtRow:	mov ebp,320
					add ecx,[zoomerdelta]					// ECX+= dY
					mov edx,[zoomerstart]
		zNxtPix:    add edx,[zoomerdelta]					// EDX+= dX
					mov bh,ch								// offset-te alakitas
					mov bl,dh

					mov ah,byte ptr [edi]					// B_old be
					mov al,byte ptr [esi + 4*ebx]			// B_new be
					and eax,0FFh
					mov al,motionblurtable[eax]
					mov byte ptr [edi],al					// B ki
					mov ah,byte ptr [edi + 1]				// G_old be
					mov al,byte ptr [esi + 4*ebx + 1]		// G_new be
					and eax,0FFh
					mov al,motionblurtable[eax]
					mov byte ptr [edi + 1],al				// G ki
					mov ah,byte ptr [edi + 2]				// R_old be
					mov al,byte ptr [esi + 4*ebx + 2]		// R_new be
					and eax,0FFh
					mov al,motionblurtable[eax]
					mov byte ptr [edi + 2],al				// G ki

					add edi,4								// kovetkezo pixel
					dec ebp
					jnz zNxtPix
					dec [zoomery]
					jnz zNxtRow

					pop ebp
	}
}

// - keretezett/nagyitott kiskep kirako -------------------------------------
void DrawMiniPicture(byte *destptr,byte *srcptr)
{ 
	__asm
	{
					// parameterek: EDI:= destptr, ESI:= srcptr

					mov edi,[destptr]
					mov esi,[srcptr]

					mov eax,0FFFFFFFFh
					mov ecx,2*33
					rep stosd
					add edi,4*(320 - 2*33 + 1)

					mov ch,32
		mNxtRow:    mov cl,32
					mov dword ptr [edi - 4],0FFFFFFFFh				// feher baloldali keret
					mov dword ptr [edi + 4*(320 - 1)],0FFFFFFFFh	// feher baloldali keret

		mNxtPix:    lodsb											// pixel be
					mov ah,al
					shl eax,8
					mov al,ah

					mov dword ptr [edi],eax							// pixel ki
					mov dword ptr [edi + 4],eax
					mov dword ptr [edi + 4*320],eax
					mov dword ptr [edi + 4*321],eax

					add edi,4*2
					dec cl											// kovetkezo pixel
					jnz mNxtPix

					mov dword ptr [edi],0FFFFFFFFh					// feher jobboldali keret
					mov dword ptr [edi + 4*320],0FFFFFFFFh			// feher jobboldali keret
					add edi,4*(2*320 - 2*32)						// kovetkezo sor
					dec ch
					jnz mNxtRow

					sub edi,4										// also keret megrajzolasa:
					mov eax,0FFFFFFFFh
					mov ecx,2*33
					rep stosd
	}
}

// - fader es crossfader ----------------------------------------------------
void FadeFrameBuffer(byte *destptr,byte fadefactor)
{ 
	__asm
	{
					// parameter: EDI -> framebuffer, ESI -> shadetable,
					//            EAX:= factor

					mov edi,[destptr]
					mov esi,offset shadetable
					movzx eax,[fadefactor]

					shl eax,8
					xor ebx,ebx
					xor edx,edx
					mov bh,ah
					mov dh,ah								// AH:= BH:= DH:= fadefactor
					mov ecx,320*180
	NxtFPix:        mov al,byte ptr [edi] ; B be
					mov bl,byte ptr [edi + 1] ;  G be
					mov dl,byte ptr [edi + 2] ;  R be
					mov al,byte ptr [esi + eax]
					mov bl,byte ptr [esi + ebx]
					mov dl,byte ptr [esi + edx]
					mov byte ptr [edi],al ; B ki
					mov byte ptr [edi + 1],bl ; G ki
					mov byte ptr [edi + 2],dl ; R ki
					add edi,4								// kovetkezo pixel
					dec ecx
					jnz NxtFPix
	}
}

void CrossFadeFrameBuffer(byte *destptr,byte *srcptr,byte fadefactor)
{ 
	static byte factor;

	__asm
	{
					// parametek: EDI:= destptr, ESI:= srcptr,
					//            EAX:= factor

					mov edi,[destptr]
					mov esi,[srcptr]
					movzx eax,[fadefactor]

					push ebp
					mov ebp,320*180

					shl eax,8
					mov [factor],ah
					xor ebx,ebx
					xor ecx,ecx
					xor edx,edx
					mov dh,ah							// DH:= factor
					xor dh,255							// AH:= (255 - factor)

		iNxtPix:    mov ah,[factor]						// AH:= factor
					mov bh,[factor]						// BH:= factor
					mov ch,[factor]						// CH:= factor
					mov al,byte ptr [edi]				// B1 be
					mov bl,byte ptr [edi + 1]			// G1 be
					mov cl,byte ptr [edi + 2]			// R1 be
					mov al,shadetable[eax]				// AL:= B1 factor arnyalatban
					mov bl,shadetable[ebx]				// BL:= G1 factor arnyalatban
					mov cl,shadetable[ecx]				// CL:= R1 factor arnyalatban

					mov dl,byte ptr [esi]				// B2
					add al,shadetable[edx]				// AL:= B1 factor arnyalatban + B2 (255 - factor) arnyalatban
					mov dl,byte ptr [esi + 1]			// G2 be
					add bl,shadetable[edx]				// BL:= G1 factor arnyalatban + G2 (255 - factor) arnyalatban
					mov dl,byte ptr [esi + 2]			// R2 be
					add cl,shadetable[edx]				// CL:= R1 factor arnyalatban + R2 (255 - factor) arnyalatban

					mov byte ptr [edi],al				// pixel ki
					mov byte ptr [edi + 1],bl
					mov byte ptr [edi + 2],cl

					add edi,4							// kovetkezo pixel
					add esi,4
					dec ebp
					jnz iNxtPix

					pop ebp
	}
}

// - legyszem-effekt rajzolo ------------------------------------------------
byte spotsprite[]= {   0,  32,  64,  32,   0, 
                      32, 128, 192, 128,  32,
					  64, 192, 224, 192,  64,
					  32, 128, 192, 128,  32,
					   0,  32,  64,  32,   0 };

void DrawFlyEye(byte *destptr)
{ 
	static dword flypixel1,flypixel2;
	__asm
	{
					// parameterek: EDI->destptr

					mov edi,[destptr]
					
					push ebp
					mov dh,18										// sorok szama

		eNxtSpotRow: push edi										// pointer elmentese
					mov dl,32										// egy sorban levo foltok

		eNxtSpot:   push edi										// pointer elmentese

					mov ch,5										// folt magassaga
					mov ebp,offset spotsprite
					mov esi,offset spotsprite
					mov eax,dword ptr [edi]
					mov [flypixel1],eax								// flypixel1:= felso_pixelertek
					mov eax,dword ptr [edi + 4*(5*320 + 5)]
					mov [flypixel2],eax								// flypixel2:= also_pixelertek

		eNxtRow:    mov cl,5										// folt szelessege
		eNxtPix:    mov al,byte ptr [ebp]							// maszkertek
					mov bl,byte ptr [esi]							// maszkertek
					or al,al
					jz eNoDrawUpper
					mov eax,[flypixel1]								// pixel be
					mov dword ptr [edi],eax							// pixel ki

		eNoDrawUpper: or bl,bl
					jz eNoDrawDowner
					mov eax,[flypixel2]								// pixel be
					mov dword ptr [edi + 4*(5*320 + 5)],eax			// pixel ki

		eNoDrawDowner:add edi,4										// kovetkezo pixel
					inc ebp
					inc esi
					dec cl
					jnz eNxtPix
					add edi,4*(320 - 5)								// kovetkezo sor
					dec ch
					jnz eNxtRow

					pop edi											// kovetkezo folt
					add edi,4*10
					dec dl
					jnz eNxtSpot

					pop edi											// kovetkezo foltsor
					add edi,4*320*10
					dec dh
					jnz eNxtSpotRow

					pop ebp
	}
}

// - radial blur (spin- es zoom blur) ---------------------------------------
void InitBlurer(byte *destptr,dword blurtype)
{ 
	dword i,j;
	gzFile gzDataFile;

	// blur-olt animaciok betoltese GZ file-bol:
	gzDataFile= gzopen("Berlin.dat","rb");

	for(i=0; i<IMAGES_BLURRED*PHASES_BLURRED; i++)
	{
		for(j=0; j<320*160; j++) 
			gzread(gzDataFile,destptr  + i*BLURBUFFER_SIZE + 4*(320*10 + j),1);
	}
	gzclose(gzDataFile);
}

void DrawBlurredImage(byte *destptr,byte *srcptr)
{ 
	__asm
	{
					// parameterek: EDI->destptr, ESI->srcptr
					mov edi,[destptr]
					mov esi,[srcptr]
					mov ecx,320*180
					xor eax,eax

	bNxtPix:		movzx eax,byte ptr [esi]	// R_old be
					mov ah,byte ptr [edi]		// R_new be
					mov al,byte ptr motionblurtable[eax]
					mov ah,al					// pixel kiegeszitese
					shl eax,8
					mov al,ah
					stosd						// pixel ki

					add esi,4					// kovetkezo pixel
					dec ecx
					jnz bNxtPix
	}
}

// - fekete-feherre konvertalo ----------------------------------------------
void ConvertMonoFrameBuffer(byte *destptr,byte *srcptr)
{ 
	__asm
	{
					// parameterek: EDI->destptr, ESI->srcptr
					mov edi,[destptr]
					mov esi,[srcptr]

					mov ecx,57920
					NxtPix: lodsd
					and eax,00000FF00h	// G kimaszkolasa 
					mov al,ah			// pixel kibovitese 
					shl eax,8
					mov al,ah
					dec ecx
					stosd
					jnz NxtPix
	}
}

// - logo rajzolo -----------------------------------------------------------
#define  LOGOPICTURE_WIDTH		214

void DrawLogo(byte *destptr)
{ 
	__asm
	{
					mov edi,[destptr]

					mov ch,147						// logo magassaga
					lea esi,logodata + 3*16			// pixeldata-ra pozicionalas
					xor eax,eax						// pixeltarolok uritese
					xor edx,edx

		lNxtRow:    mov cl,LOGOPICTURE_WIDTH/2		// logo szelessegenek fele
		lNxtPix:    lodsb
					mov dl,al
					and al,0F0h						// pixelek kimaszkolasa
					and dl,00Fh
					shr al,4
					imul eax,3						// palettaoffszetek szamitasa
					imul edx,3

					mov bl,byte ptr [logodata + eax + 0]	// R1 be
					mov byte ptr [edi + 2],bl				// R1 ki
					mov bl,byte ptr [logodata + eax + 1]	// G1 be
					mov byte ptr [edi + 1],bl				// G1 ki
					mov bl,byte ptr [logodata + eax + 2]	// B1 be
					mov byte ptr [edi + 0],bl				// B1 ki

					mov bl,byte ptr [logodata + edx + 0]	// R2 be
					mov byte ptr [edi + 4 + 2],bl			// R2 ki
					mov bl,byte ptr [logodata + edx + 1]	// G2 be
					mov byte ptr [edi + 4 + 1],bl			// G2 ki
					mov bl,byte ptr [logodata + edx + 2]	// B2 be
					mov byte ptr [edi + 4 + 0],bl			// B2 ki

					add edi,2*4
					dec cl									// kovetkezo pixel
					jnz lNxtPix
					add edi,4*(320 - LOGOPICTURE_WIDTH)
					dec ch
					jnz lNxtRow
	}
}

// - villantas --------------------------------------------------------------
void BlinkFrameBuffer(byte *destptr,dword factor)
{ 
	__asm
	{
					// parametek: EDI-> destptr, EAX:= factor
					
					mov edi,[destptr]
					mov eax,[factor]

					mov ecx,320*180
					shl eax,8
					mov ebx,eax
					xor bh,0FFh						// BH:= factor XOR 0xFF

		fNxtPix:    mov al,byte ptr [edi]			// B be
					mov bl,al
					xor bl,0FFh
					mov dl,shadetable[eax]			// DL:= shadetable[intensity][factor]
					add dl,shadetable[ebx]
					mov byte ptr [edi],dl

					mov al,byte ptr [edi + 1]		// G be
					mov bl,al
					xor bl,0FFh
					mov dl,shadetable[eax]			// DL:= shadetable[intensity][factor]
					add dl,shadetable[ebx]
					mov byte ptr [edi + 1],dl

					mov al,byte ptr [edi + 2]		// B be
					mov bl,al
					xor bl,0FFh
					mov dl,shadetable[eax]			// DL:= shadetable[intensity][factor]
					add dl,shadetable[ebx]
					mov byte ptr [edi + 2],dl

					add edi,4						// kovetkezo pixel
					dec ecx
					jnz fNxtPix
	}
}

// - additiv polarkoordinatas bitmapeffekt ----------------------------------
byte polartable[520*281*2];
dword polaroffset2,polaroffset3;

void InitPolarizator(void)
{ 
	signed int x,y;
	dword index= 0;
	float dX,dY,distance,angle;

	for(y=0; y<281; y++) for(x=0; x<520; x++)
	{ 
		// tavolsag a kepernyo kozeppontjatol:
		dX= x - 260.0f; dY= y - 140.0f;
		distance= (float)sqrt(dX*dX*0.8*0.8 + dY*dY);
		// szog a kepernyo kozeppontjahoz huzott vektorral:
		if(distance) angle= (float)acos(dY/distance); else angle= 0;
		if(angle < 0.0) angle= -angle;

		// tablazat kitoltese (2*i <- distance, 2*i + 1 <- angle):
		polartable[index]= (byte)(((dword)distance) % 256);
		polartable[index + 1]= (byte)(128.0*angle);

		// kovetkezo bejegyzes:
		index+= 2;
	}
}

void PolarizeBitmap(byte *destptr,dword offset1,dword offset2,dword offset3,
                    byte *srcptr,byte dadder,byte aadder,
                    byte *srcptr2,byte dadder2,byte aadder2)
{ 
	static dword polarx,polary;

	distanceadder= dadder; angleadder= aadder;
	distanceadder2= dadder2; angleadder2= aadder2;

	polaroffset2= offset2; polaroffset3= offset3;

	__asm
	{
					// parameterek: EDI:= destptr, EAX:= tableoffsetadder,
					//              ESI:= srcptr, ECX:= srcptr2

					mov edi,[destptr]
					mov eax,[offset1]
					mov esi,[srcptr]
					mov ecx,[srcptr2]

					push ebp
					mov ebp,eax				// EBP:= tableoffsetadder
					xor eax,eax
					xor edx,edx

					mov [polary],180
	oNxtLin:        mov [polarx],320
	oNxtPix:        movzx ebx,word ptr polartable[ebp]	// texturakoordinatak betoltese
		            push ebp
					mov ebp,[polaroffset2]
					add bh,polartable[ebp]
					add bl,polartable[ebp + 1]
					mov ebp,[polaroffset3]
					add bh,polartable[ebp]
					add bl,polartable[ebp + 1]
					pop ebp
					and ebx,0FFFFh

					mov dx,bx
					add bh,[distanceadder2]
					add dh,[distanceadder]
					add bl,[angleadder2]				// EBX:= 4*(256*distance2 + angle2)
					add dl,[angleadder]					// EDX:= 4*(256*distance + angle)

					mov al,byte ptr [esi + 4*edx + 0]	// B1 be
					mov ah,byte ptr [ecx + 4*ebx + 0]	// B2 be
					mov ah,motionblurtable[eax]
					mov al,byte ptr [edi + 0]			// B_old be
					mov al,motionblurtable[eax]
					mov byte ptr [edi + 0],al			// B ki

					mov al,byte ptr [esi + 4*edx + 1]	// G1 be
					mov ah,byte ptr [ecx + 4*ebx + 1]	// G2 be
					mov ah,motionblurtable[eax]
					mov al,byte ptr [edi + 1]			// G_old be
					mov al,motionblurtable[eax]
					mov byte ptr [edi + 1],al			// G ki

					mov al,byte ptr [esi + 4*edx + 2]	// R1 be
					mov ah,byte ptr [ecx + 4*ebx + 2]	// R2 be
					mov ah,motionblurtable[eax]
					mov al,byte ptr [edi + 2]			// R_old be
					mov al,motionblurtable[eax]
					mov byte ptr [edi + 2],al			// R ki

					add edi,4							// kovetkezo pixel
					add ebp,2
					add [polaroffset2],2
					add [polaroffset3],2
					dec [polarx]
					jnz oNxtPix

					add ebp,2*(520 - 320)				// kovetkezo sor
					add [polaroffset2],2*(520 - 320)
					add [polaroffset3],2*(520 - 320)
					dec [polary]
					jnz oNxtLin

					pop ebp
	}
}

// - keptorzitas "golyoval" -------------------------------------------------
dword torsiontable[320*180*2];

void RecalcTorsionTable(signed int cX1,signed int cY1,signed int cX2,signed int cY2)
{ 
	signed int x,y,index= 0;
	signed int dX,dY,distance1,distance2;
	signed int a,b;

	// 320x180-as kep torzitasa:
	for(y=-180; y<180; y+=2) for(x=-320; x<320; x+=2)
	{ 
		// torzitas 2 blob-bal:
		dX= x - cX1; dY= y - cY1; distance1= (dX*dX + dY*dY)>>6;
		dX= x - cX2; dY= y - cY2; distance2= (dX*dX + dY*dY)>>6;
		if(distance2 < distance1) distance1= distance2;
		// X/Y torzitas 32bites modban:
		a= ((160<<16) - x*distance1)>>16;
		b= ((90<<16) - y*distance1)>>16;
		if(a < 0) a= 0; else if(a > 319) a= 319;
		if(b < 0) b= 0; else if(b > 179) b= 179;
		torsiontable[index]= 319 - a - 50;
		torsiontable[index + 1]= 179 - b;
		// kovetkezo elem:
		index+= 2;
	}
}

void DistortBitmap(byte *destptr,byte *srcptr)
{ 
	__asm
	{
					// parameterek: EDI->destptr, ESI->srcptr
					mov edi,[destptr]
					mov esi,[srcptr]

					lea ebx,torsiontable				// precalc tablara mutat 
					mov ecx,57600						// 320x180 pixel 
		NxtPix:		mov eax,dword ptr [ebx + 4]
					mov edx,eax
					shl eax,8
					shl edx,6
					add eax,edx
					add eax,dword ptr [ebx]				// EAX:= dY*320 + dX 
					mov dl,byte ptr [esi + eax*4 + 0]	// pixel be 
					mov dh,byte ptr [edi + 0]			// pixel be 
					mov dl,motionblurtable[edx]
					mov byte ptr [edi + 0],dl
					mov dl,byte ptr [esi + eax*4 + 1]	// pixel be 
					mov dh,byte ptr [edi + 1]			// pixel be 
					mov dl,motionblurtable[edx]
					mov byte ptr [edi + 1],dl
					mov dl,byte ptr [esi + eax*4 + 2]	// pixel be 
					mov dh,byte ptr [edi + 2]			// pixel be 
					mov dl,motionblurtable[edx]
					mov byte ptr [edi + 2],dl
					add edi,4							// kovetkezo pixel 
					add ebx,8
					dec ecx
					jnz NxtPix
	}
}

// - keprangatas effekt -----------------------------------------------------
void TwitchFrameBuffer(byte *destptr,byte *srcptr,dword row)
{ 
	__asm
	{
					// parameterek: EDI->destptr, ESI->srcptr, EDX:= row

					mov edi,[destptr]
					mov esi,[srcptr]
					mov edx,[row]
					add row,30

					mov ecx,180
					push esi						// ESI elmentese 
					sub ecx,edx
					imul edx,1280					// EDX:= 4*320*rows 
					imul ecx,320					// ECX:= 320*(180 - rows) 
					add esi,edx
					mov ebx,ecx						// EBX szamolja az atmasolt pixeleket 
					rep movsd						// rows sor atugrasaval masolas 
					xor eax,eax
					mov ecx,6400					// 20*320 fekete pixel 
					add ebx,6400
					rep stosd
					pop esi							// ESI vissza 
					mov ecx,320*180
					sub ecx,ebx						// visszamaradt pixelek 
					rep movsd
	}
}

// - texturazott bump -------------------------------------------------------
dword lightsource_adder;

void DrawBump(byte *destptr,byte *srcptr,dword X,dword Y)
{
	static dword bumpx;
	static byte bumpy;
	
	lightsource_adder= 256*Y + X;

	__asm
	{
					// parameterek: EDI->destptr, ESI->srcptr, EDX:= lightsource_adder
					mov edi,[destptr]
					mov esi,[srcptr]
					mov edx,[lightsource_adder]

					xor eax,eax
					xor ebx,ebx

					add esi,4*320							// also es felso sor kimarad
					add edi,4*320
					mov [bumpy],179
		uNxtLin:	mov [bumpx],320
		uNxtPix:    movzx ebx,[bumpx]						// torzitas kiszamitasa G komponens alapjan
					add bl,byte ptr [esi - 4 + 1]
					sub bl,byte ptr [esi + 4 + 1]			// BL:= dX + (x>>1)
					mov bh,[bumpy]
					add bh,byte ptr [esi - 4*320 + 1]
					sub bh,byte ptr [esi + 4*320 + 1]		// BH:= dY + (y>>1)
					add bx,dx								// fenyforras kezdopoziciojanak hozzadasa

					movzx bx,byte ptr Phongmap[ebx]			// BL:= fenyesseg

					movzx ax,byte ptr [esi + 0]				// B be
					add al,bl
					jnc uNoTruncB
					mov al,255
		uNoTruncB:  mov byte ptr [edi + 0],al				// B ki

					movzx ax,byte ptr [esi + 1]				// G be
					add al,bl
					jnc uNoTruncG
					mov al,255
		uNoTruncG:  mov byte ptr [edi + 1],al				// G ki

					movzx ax,byte ptr [esi + 2]				// R be
					add al,bl
					jnc uNoTruncR
					mov al,255
		uNoTruncR:  mov byte ptr [edi + 2],al				// R ki

					add esi,4								// kovetkezo pixel
					add edi,4
					dec [bumpx]
					jnz uNxtPix

					dec [bumpy]								// kovetkezo sor
					jnz uNxtLin
	}
}

// - shaded csikok oldalra --------------------------------------------------
void DrawStripes(byte *destptr)
{ 
	__asm
	{
					// parameterek: EDI->destptr

					mov edi,[destptr]

					xor eax,eax								// pixeltarolo uritese

					mov ebx,180
		aNxtLin:    xor edx,edx
		aNxtPix:    mov ah,255								// 60- shade: 255
					cmp edx,60
					ja aLOK
					mov ah,240								// 40-60 shade: 240
					cmp edx,40
					ja aLOK
					mov ah,200								// 20-40 shade: 180
					cmp edx,20
					ja aLOK
					mov ah,150								// -20 shade: 130
		aLOK:       cmp edx,320 - 60
					jb aROK
					mov ah,240
					cmp edx,320 - 40
					jb aROK
					mov ah,200
					cmp edx,320 - 20
					jb aROK
					mov ah,150

		aROK:       mov al,byte ptr [edi]					// B be
					mov al,shadetable[eax]
					mov byte ptr [edi],al					// B ki

					mov al,byte ptr [edi + 1]				// G be
					mov al,shadetable[eax]
					mov byte ptr [edi + 1],al				// G ki

					mov al,byte ptr [edi + 2]				// R be
					mov al,shadetable[eax]
					mov byte ptr [edi + 2],al				// R ki

					add edi,4								// kovetkezo pixel
					inc edx
					cmp edx,320
					jne aNxtPix

					dec ebx									// kovetkezo sor
					jnz aNxtLin
	}
}

// - kockazas effekt --------------------------------------------------------
byte columns;

void DrawSquares(byte *destptr)
{ 
	// "kockazas":
	columns= 23;
  
	__asm
	{
					// parameter: EDI->destptr

					mov edi,[destptr]

					add edi,4*180
		NxtRow:		mov edx,12
		NxtPix:		mov eax,dword ptr [edi + 4*(2*320 + 2)]		// pixel be
					mov ecx,8
		NxtDpH:		push edi				// EDI elmentese fuggoleges sokszorozas elott 
					mov ebx,8
		NxtDpV:		mov dword ptr [edi],eax
					add edi,1280			// fuggoleges lepes 
					dec ebx
					jnz NxtDpV
					pop edi					// EDI visszatoltese vizszintes lepeshez 
					add edi,4				// vizszintes lepes 
					dec ecx
					jnz NxtDpH
					dec edx					// kovetkezo pixel 
					jnz NxtPix
					add edi,4*(8*320 - 8*12) 
					dec [columns]
					jnz NxtRow
	}
}

// - invertalt csik rajzolo -------------------------------------------------
void DrawInvertedStripe(byte *destptr,dword factor)
{ 
	__asm
	{
					// parameterek: EDI->destptr, EBX:= factor

					mov edi,[destptr]
					mov ebx,[factor]
					push ebp
					mov ebp,edi
					add ebp,4*320*179 
					mov ecx,90										// sorok: 178/2 
		NxtRow:		mov eax,ebx										// EAX:= factor 
					and eax,6
					cmp eax,4
					ja NoDraw										// nem kell rajzolni 
					mov edx,6										// csik szelessege 
		NxtPix:		xor dword ptr [edi + 40 + edx*4],0FFFFFFFFh		//invertalas: 4x10 
					xor dword ptr [edi + 1324 + edx*4],0FFFFFFFFh	//4x10 + 4x320 + 4 
					xor dword ptr [ebp + 1192 + edx*4],0FFFFFFFFh	//4x298 
					xor dword ptr [ebp + 2476 + edx*4],0FFFFFFFFh	// 4x298 + 4x320 + 4 
					sub edx,2
					jnz NxtPix
		NoDraw:		add edi,4*2*320									// kovetkezo sor: 4x2x320
					sub ebp,4*2*320
					dec ebx											// factor-- 
					dec ecx
					jnz NxtRow
					pop ebp
	}
}

// - kereteltakaro rutin ----------------------------------------------------
void HideBorders(byte *destptr)
{ 
	__asm
	{
					// parameterek: EDI->destptr

					mov edi,[destptr]

					xor eax,eax							// torlo szin 
					push edi
					mov ecx,320							// felso es also border torlese 
		NxtPix:		mov dword ptr [edi + 229120],eax	// 4x179x320 
					stosd
					dec ecx
					jnz NxtPix
					pop edi
					mov ecx,178							// oldalso border-ek torlese: 
		NxtRow:		add edi,4*320
					mov dword ptr [edi],eax
					mov dword ptr [edi + 4*319],eax
					dec ecx
					jnz NxtRow
	}
}

// - stroboszkop rutin ------------------------------------------------------
void HandleStrobo(byte *destptr,signed int strobovalue)
{
	__asm
	{
					mov edi,[destptr]
					mov edx,[strobovalue]

					cmp edx,0					// DL-ben parameter a strobovalue 
					jle NoFlash

					mov ecx,320*180
	NxtStr:         mov al,byte ptr [edi]		// B be 
					mov bl,byte ptr [edi + 1]	// G be 
					mov ah,byte ptr [edi + 2]	// R be 
					cmp al,dl
					jae NoFlshB
					mov byte ptr [edi],dl		// B villan 
	NoFlshB:        cmp bl,dl
					jae NoFlshG
					mov byte ptr [edi + 1],dl	// G villan 
	NoFlshG:        cmp ah,dl
					jae NoFlshR
					mov byte ptr [edi + 2],dl	// R villan 
	NoFlshR:        add edi,4					// kovetkezo pixel 
					dec ecx
					jnz NxtStr
	NoFlash:       
	}
}

// - framebuffer masolo- es feltolto rutinok --------------------------------
void CopyFrameBuffer(byte *destptr,byte *srcptr)
{
	__asm
	{
					mov edi,[destptr]
					mov esi,[srcptr]

					mov ecx,320*180 
					rep movsd
	}
}

void FillFrameBuffer(byte *destptr,dword pixel)
{
	__asm
	{
					mov edi,[destptr]
					mov eax,[pixel]
					
					mov ecx,320*180 
					rep stosd
	}
}

// - framebuffer interpolatorok (1x1-es dummy,2x2-es es 4x4-es) -------------
void InterpolateFrameBuffer1(byte *destptr)
{
}

void InterpolateFrameBuffer2(byte *destptr)
{
	__asm
	{
					// parameter: EDI -> framebuffer
					mov edi,[destptr]
					push ebp

					// vizszintes interpolacio:
					push edi
					mov ebp,91			// sorok
	NxtLine2:		mov esi,160			// interpolalando pixelek
	NxtTriplet2:    xor eax,eax			// pixeltarolok es deltak uritese
					xor ebx,ebx
					xor ecx,ecx
					xor edx,edx

					mov ah,byte ptr [edi]			// B1 be
					mov ch,byte ptr [edi + 1]		// G1 be
					mov bh,byte ptr [edi + 2*4]		// B2 be
					mov dh,byte ptr [edi + 2*4 + 1] // G2 be

					sub ebx,eax						// B2 - B1
					sub edx,ecx						// G2 - G1
					sar ebx,1						// BX:= ((B2 - B1)<<8)/2
					sar edx,1						// DX:= ((G2 - G1)<<8)/2

					add eax,ebx
					add ecx,edx
					mov byte ptr [edi + 4],ah
					mov byte ptr [edi + 4 + 1],ch

					xor eax,eax
					xor ebx,ebx
					mov ah,byte ptr [edi + 2]		// R1 be
					mov bh,byte ptr [edi + 2*4 + 2] // R2 be
					sub ebx,eax ; R2 - R1
					sar ebx,1						// BX:= ((R2 - R1)<<8)/4
					add eax,ebx
					mov	byte ptr [edi + 4 + 2],ah

					add edi,2*4						// kovetkezo pixel 2-vel jobbra
					dec esi
					jnz NxtTriplet2
					add edi,4*320					// kovetkezo sor 2-vel lejjebb
					dec ebp
					jnz	NxtLine2

					// fuggoleges interpolacio
					pop edi
					mov ebp,90
	NxtHLine2:		mov esi,320						// interpolalando pixelek
	NxtHTriplet2:   xor eax,eax						// pixeltarolok es deltak uritese
		            xor ebx,ebx
			        xor ecx,ecx
				    xor edx,edx

					mov ah,byte ptr [edi]					// B1 be
	                mov ch,byte ptr [edi + 1]				// G1 be
		            mov bh,byte ptr [edi + 2*4*320]			// B2 be
			        mov dh,byte ptr [edi + 2*4*320 + 1]		// G2 be

					sub ebx,eax						// B2 - B1
					sub edx,ecx						// G2 - G1
					sar ebx,1						// BX:= ((B2 - B1)<<8)/2
					sar edx,1						// DX:= ((G2 - G1)<<8)/2

					add eax,ebx
					add ecx,edx
					mov byte ptr [edi + 4*320],ah
					mov byte ptr [edi + 4*320 + 1],ch

					xor eax,eax
	                xor ebx,ebx
		            mov ah,byte ptr [edi + 2]				// R1 be
			        mov bh,byte ptr [edi + 2*4*320 + 2]		// R2 be
				    sub ebx,eax								// R2 - R1
					sar ebx,1								// BX:= ((R2 - R1)<<8)/2

	                add eax,ebx
		            mov byte ptr [edi + 4*320 + 2],ah

	                add edi,4								// kovetkezo pixel 1-el jobbra
		            dec esi
			        jnz NxtHTriplet2
				    add edi,4*320							// kovetkezo sor 2-vel lejjebb
					dec ebp
	                jnz NxtHLine2

					pop ebp
	}
}

void InterpolateFrameBuffer4(byte *destptr)
{
	__asm
	{
					// parameter: EDI -> framebuffer
					mov edi,[destptr]
					push ebp

					// vizszintes interpolacio
					push edi
					mov ebp,46								// sorok
		NxtLine:    mov esi,80								// interpolalando pixelek
		NxtTriplet: xor eax,eax								// pixeltarolok es deltak uritese
					xor ebx,ebx
					xor ecx,ecx
					xor edx,edx

					mov ah,byte ptr [edi]					// B1 be
					mov ch,byte ptr [edi + 1]				// G1 be
					mov bh,byte ptr [edi + 4*4]				// B2 be
					mov dh,byte ptr [edi + 4*4 + 1]			// G2 be

					sub ebx,eax								// B2 - B1
					sub edx,ecx								// G2 - G1
					sar ebx,2								// BX:= ((B2 - B1)<<8)/4
					sar edx,2								// DX:= ((G2 - G1)<<8)/4

					add eax,ebx
					add ecx,edx
					mov byte ptr [edi + 4],ah
					mov byte ptr [edi + 4 + 1],ch
					add eax,ebx
					add ecx,edx
					mov byte ptr [edi + 2*4],ah
					mov byte ptr [edi + 2*4 + 1],ch
					add eax,ebx
					add ecx,edx
					mov byte ptr [edi + 3*4],ah
					mov byte ptr [edi + 3*4 + 1],ch

					xor eax,eax
					xor ebx,ebx
					mov ah,byte ptr [edi + 2]				// R1 be
					mov bh,byte ptr [edi + 4*4 + 2]			// R2 be
					sub ebx,eax								// R2 - R1
					sar ebx,2								// BX:= ((R2 - R1)<<8)/4

					add eax,ebx
					mov byte ptr [edi + 4 + 2],ah
					add eax,ebx
					mov byte ptr [edi + 2*4 + 2],ah
					add eax,ebx
					mov byte ptr [edi + 3*4 + 2],ah

					add edi,4*4								// kovetkezo pixel 4-gyel jobbra
					dec esi
					jnz NxtTriplet
					add edi,3*4*320							// kovetkezo sor 4-gyel lejjebb
					dec ebp
					jnz NxtLine

					// fuggoleges interpolacio:
					pop edi
					mov ebp,45
		NxtHLine:   mov esi,320								// interpolalando pixelek
		NxtHTriplet: xor eax,eax							// pixeltarolok es deltak uritese
					xor ebx,ebx
					xor ecx,ecx
					xor edx,edx

					mov ah,byte ptr [edi]					// B1 be
					mov ch,byte ptr [edi + 1]				// G1 be
					mov bh,byte ptr [edi + 4*4*320]			// B2 be
					mov dh,byte ptr [edi + 4*4*320 + 1]		// G2 be

					sub ebx,eax								// B2 - B1
					sub edx,ecx								// G2 - G1
					sar ebx,2								// BX:= ((B2 - B1)<<8)/4
					sar edx,2								// DX:= ((G2 - G1)<<8)/4

					add eax,ebx
					add ecx,edx
					mov byte ptr [edi + 4*320],ah
					mov byte ptr [edi + 4*320 + 1],ch
					add eax,ebx
					add ecx,edx
					mov byte ptr [edi + 2*4*320],ah
					mov byte ptr [edi + 2*4*320 + 1],ch
					add eax,ebx
					add ecx,edx
					mov byte ptr [edi + 3*4*320],ah
					mov byte ptr [edi + 3*4*320 + 1],ch

					xor eax,eax
					xor ebx,ebx
					mov ah,byte ptr [edi + 2]				// R1 be
					mov bh,byte ptr [edi + 4*4*320 + 2]		// R2 be
					sub ebx,eax								// R2 - R1
					sar ebx,2								// BX:= ((R2 - R1)<<8)/4

					add eax,ebx
					mov byte ptr [edi + 4*320 + 2],ah
					add eax,ebx
					mov byte ptr [edi + 2*4*320 + 2],ah
					add eax,ebx
					mov byte ptr [edi + 3*4*320 + 2],ah

					add edi,4								// kovetkezo pixel 1-el jobbra
					dec esi
					jnz NxtHTriplet
					add edi,3*4*320							// kovetkezo sor 4-gyel lejjebb
					dec ebp
					jnz NxtHLine

					pop ebp
	}
}